<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <title>Bulletins de Paie</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            color: #1f1e1e;
        }

        .logo-title-table,
        .main-table,
        .header-table,
        .signature-table {
            width: 100%;
            border-collapse: collapse;
        }

        .logo-title-table td,
        .header-table td,
        .main-table th,
        .main-table td,
        .signature-table td {
            padding: 4px;
        }

        .header-table td,
        .main-table th,
        .main-table td {
            border: 1px solid #575656;
        }

        .main-table th {
            background-color: #f0f0f0;
            text-align: center;
        }

        .bold {
            font-weight: bold;
        }

        .right {
            text-align: right;
        }

        .left {
            text-align: left;
        }

        .center {
            text-align: center;
        }

        .section-title {
            background-color: #f9f9f9;
            font-weight: bold;
        }

        .footer {
            margin-top: 10px;
            text-align: right;
            font-weight: bold;
        }

        .status {
            position: fixed;
            left: 50%;
            top: 50%;
            transform: translate(-50%, -50%) rotate(45deg);
            transform-origin: center;
            font-size: 60px;
            font-weight: 800;
            letter-spacing: 0.5rem;
            color: rgba(0, 0, 0, 0.06);
            z-index: 0;
            pointer-events: none;
            user-select: none;
            white-space: nowrap;
            text-transform: uppercase;
            mix-blend-mode: multiply;
        }

        .no-border {
            border: 0px !important;
        }

        .page-break {
            page-break-after: always;
        }
    </style>
</head>

<body>

    <?php $__currentLoopData = $payrolls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payroll): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $daysDeclared = $payroll->employee->daysDeclared > 0 ? $payroll->employee->daysDeclared : 26;
            $workingHours = $payroll->employee->workingHours > 0 ? $payroll->employee->workingHours : 8;
            $salary = $payroll->employee->salary > 0 ? $payroll->employee->salary : 3266.1; // SMIG fallback
        ?>

        <div class="payslip">
            <h1 class="status"><?php echo e($payroll->status ?? '-'); ?></h1>

            
            <table class="logo-title-table">
                <tr>
                    <td class="left">
                        <img width="120" height="40" src="<?php echo e(config('app.company.logo')); ?>" />
                    </td>
                    <td class="right">
                        <h2>BULLETIN DE PAIE</h2>
                    </td>
                </tr>
            </table>

            <table class="logo-title-table">
                <tr>
                    <td class="left" style="width: 50%">
                        <div><strong>RS :</strong> <?php echo e(company('raison_sociale')); ?></div>
                        <div><strong>RC :</strong> <?php echo e(company('rc')); ?></div>
                        <div><strong>ICE :</strong> <?php echo e(company('ice')); ?></div>
                        <div><strong>Patente :</strong> <?php echo e(company('patente')); ?></div>
                        <div><strong>IF :</strong> <?php echo e(company('if')); ?></div>
                        <div><strong>CNSS :</strong> <?php echo e(company('cnss')); ?></div>
                    </td>
                    <td style="width: 50%">
                        <div><strong>Adresse :</strong> <?php echo e(company('adresse')); ?></div>
                        <div><strong>Téléphone :</strong> <?php echo e(company('tel')); ?></div>
                        <div><strong>Email :</strong> <?php echo e(company('email')); ?></div>
                        <div><strong>Responsable :</strong> <?php echo e(company('responsable')); ?></div>
                        <div><strong>RIB :</strong> <?php echo e(company('rib')); ?></div>
                    </td>
                </tr>
            </table>

            <br>

            
            <table class="header-table">
                <tr>
                    <td><b>La paie de mois :</b> <?php echo e($payroll->month ?? '-'); ?>,
                        <b>Fais le :</b> <?php echo e($payroll->date ? $payroll->date->format('d M Y') : '--'); ?>

                        <?php if($payroll->approvedBy): ?>
                            et validé par <?php echo e($payroll->approvedBy); ?>,
                            le <?php echo e($payroll->approvedAt ? $payroll->approvedAt->format('d-m-Y') : '--'); ?>

                        <?php endif; ?>
                    </td>
                    <td><b>Année fiscale :</b> <?php echo e($payroll->calculation_year ?? '-'); ?></td>
                </tr>
            </table>

            <table class="header-table">
                <tr>
                    <td><b>Nom :</b> <?php echo e($payroll->name ?? '-'); ?></td>
                    <td><b>Date embauche :</b> <?php echo e($payroll->employee->hireDate->format('d-m-Y') ?? '-'); ?></td>
                    <td><b>N° CNSS :</b> <?php echo e($payroll->employee->cnssNumber ?? '-'); ?></td>
                    <td><b>Matricule :</b> <?php echo e($payroll->employee->matricule ?? '-'); ?></td>
                </tr>
                <tr>
                    <td><b>Poste :</b> <?php echo e($payroll->employee->jobTitle ?? '-'); ?></td>
                    <td><b>Département :</b> <?php echo e($payroll->employee->department ?? '-'); ?></td>
                    <td><b>Nbr déductions :</b> <?php echo e($payroll->employee->relatedPerson ?? '0'); ?></td>
                    <td><b>Paiment :</b> <?php echo e($payroll->paymentMethod ?? '-'); ?></td>
                </tr>
            </table>

            <br>

            
            <table class="main-table">
                <thead>
                    <tr>
                        <th>RUBRIQUE</th>
                        <th>BASE (Dh)</th>
                        <th>(J,H)</th>
                        <th>TAUX</th>
                        <th>GAINS (Dh)</th>
                        <th>RETENUES (Dh)</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Salaire de base mensuel</td>
                        <td><?php echo e(number_format($salary, 2, ',', ' ')); ?></td>
                        <td><?php echo e(number_format($payroll->totalWorkedRegularHours / $workingHours, 2, ',', ' ')); ?> J</td>
                        <td>--</td>
                        <td><?php echo e(number_format(($salary / $daysDeclared) * ($payroll->totalWorkedRegularHours / $workingHours), 2, ',', ' ')); ?>

                        </td>
                        <td>--</td>
                    </tr>

                    
                    <?php if(!empty($payroll->detailSuppl)): ?>
                        <?php $__currentLoopData = json_decode($payroll->detailSuppl, true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($supp['label']); ?></td>
                                <td><?php echo e(number_format($supp['base_regulier'], 2, ',', ' ')); ?></td>
                                <td><?php echo e($supp['nbrHour']); ?> H</td>
                                <td><?php echo e($supp['rateLabel']); ?></td>
                                <td><?php echo e(number_format($supp['amount'], 2, ',', ' ')); ?></td>
                                <td>--</td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>

                    
                    <?php if(!empty($payroll->compensation['details'])): ?>
                        <?php $__currentLoopData = $payroll->compensation['details']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $isTaxable = filter_var($detail['taxable'] ?? false, FILTER_VALIDATE_BOOLEAN);
                            ?>
                            <tr>
                                <td><?php echo e($detail['compensation_name'] ?? ($detail['allowance_label'] ?? '-')); ?></td>
                                <td><?php echo e(number_format($detail['base'] ?? 0, 2, ',', ' ')); ?></td>
                                <td>--</td>
                                <td><?php echo e(isset($detail['rate_percentage']) ? $detail['rate_percentage'] . '%' : '--'); ?>

                                </td>
                                <td><?php echo e($isTaxable ? number_format($detail['amount'] ?? 0, 2, ',', ' ') : '--'); ?></td>
                                <td><?php echo e(!$isTaxable ? number_format($detail['amount'] ?? 0, 2, ',', ' ') : '--'); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>

                    <tr>
                        <td colspan="5" class="bold">Salaire brut imposable</td>
                        <td class="bold"><?php echo e(number_format($payroll->grossSalary ?? 0, 2, ',', ' ')); ?></td>
                    </tr>

                    <tr>
                        <td>Frais professionnels</td>
                        <td><?php echo e(number_format($payroll->grossSalary, 2, ',', ' ')); ?></td>
                        <td>--</td>
                        <td><?php echo e(number_format($payroll->proFeesRate, 2, ',', ' ')); ?>%</td>
                        <td>--</td>
                        <td><?php echo e(number_format($payroll->proFees, 2, ',', ' ')); ?></td>
                    </tr>

                    <tr>
                        <td>CNSS</td>
                        <td><?php echo e(number_format($payroll->cnssBase, 2, ',', ' ')); ?></td>
                        <td>--</td>
                        <td><?php echo e(number_format($payroll->cnssRate, 2, ',', ' ')); ?>%</td>
                        <td>--</td>
                        <td><?php echo e(number_format($payroll->cnss, 2, ',', ' ')); ?></td>
                    </tr>

                    <tr>
                        <td>AMO</td>
                        <td><?php echo e(number_format($payroll->grossSalary, 2, ',', ' ')); ?></td>
                        <td>--</td>
                        <td><?php echo e(number_format($payroll->amoRate, 2, ',', ' ')); ?>%</td>
                        <td>--</td>
                        <td><?php echo e(number_format($payroll->amo, 2, ',', ' ')); ?></td>
                    </tr>

                    <tr>
                        <td>Indemnité pour Perte d’Emploi</td>
                        <td><?php echo e(number_format($payroll->grossSalary, 2, ',', ' ')); ?></td>
                        <td>--</td>
                        <td><?php echo e(number_format($payroll->lossJobRate, 2, ',', ' ')); ?>%</td>
                        <td>--</td>
                        <td><?php echo e(number_format($payroll->lossJobCompensation, 2, ',', ' ')); ?></td>
                    </tr>

                    <tr>
                        <td>Retraite</td>
                        <td><?php echo e(number_format($payroll->grossSalary, 2, ',', ' ')); ?></td>
                        <td>--</td>
                        <td><?php echo e(number_format($payroll->retretirementRate, 2, ',', ' ')); ?>%</td>
                        <td>--</td>
                        <td><?php echo e(number_format($payroll->retretirement, 2, ',', ' ')); ?></td>
                    </tr>

                    <tr>
                        <td>Impot sur le revenu (IR)</td>
                        <td><?php echo e(number_format($payroll->grossSalary - $payroll->totalDeductions, 2, ',', ' ')); ?></td>
                        <td>--</td>
                        <td><?php echo e(number_format($payroll->irRate, 2, ',', ' ')); ?>%</td>
                        <td>--</td>
                        <td><?php echo e(number_format($payroll->ir, 2, ',', ' ')); ?></td>
                    </tr>

                    <tr>
                        <td colspan="5" class="bold">Total des retenues</td>
                        <td class="bold"><?php echo e(number_format($payroll->totalDeductions ?? 0, 2, ',', ' ')); ?></td>
                    </tr>

                    <tr>
                        <td colspan="1" class="bold">Salaire net</td>
                        <td colspan="4" class="bold"><?php echo e($payroll->netSalaryInWord); ?></td>
                        <td class="bold"><?php echo e(number_format($payroll->netSalary ?? 0, 2, ',', ' ')); ?></td>
                    </tr>
                </tbody>
            </table>

            <table class="signature-table no-border">
                <tr>
                    <td>Signature de l'employé :</td>
                    <td width="160">Signature de l'employeur :</td>
                </tr>
            </table>
        </div>

        <?php if(!$loop->last): ?>
            <div class="page-break"></div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</body>

</html>
<?php /**PATH E:\proxywork-erp\proxywork-backend\resources\views\payroll\payslip.blade.php ENDPATH**/ ?>