<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <title>{{ getDocTypeLabel($operation["docType"]) }} - {{ $operation["docId"] }}</title>
    <style>
        :root {
            --primary-color: #000;
            --secondary-color: #555;
            --border-color: #DDD;
            --spacing-sm: 10px;
            --spacing-md: 15px;
            --spacing-lg: 20px;
            --spacing-xl: 40px;
            --font-size-base: 14px;
            --font-size-large: 16px;
            --font-size-small: 12px;
        }

        body {
            font-family: Arial, Helvetica, sans-serif;
            font-size: var(--font-size-base);
            color: var(--primary-color);
            margin: 0;
            padding: 0;
            position: relative;
        }

        .container {
            width: 100%;
            max-width: 210mm;
            /* A4 width */
            margin: 0 auto;
        }

        .bg {
            position: fixed;
            top: 50%;
            left: 50%;
            width: 600px;
            height: 600px;
            background: url("logo.png") center / contain no-repeat;
            opacity: 0.1;
            z-index: 0;
            transform: translate(-50%, -50%) rotate(45deg);
            /* rotate 45° */
        }


        .text-left {
            text-align: left !important;
        }

        .text-center {
            text-align: center !important;
        }

        .text-right {
            text-align: right !important;
        }

        .bold {
            font-weight: bold;
        }

        .italic {
            font-style: italic;
        }

        .no-border {
            border: none !important;
        }

        .vertical-top {
            vertical-align: top;
        }

        .vertical-middle {
            vertical-align: middle;
        }

        .mb-16 {
            margin-bottom: 16px;
        }

        .mt-20 {
            margin-top: var(--spacing-lg);
        }

        .mt-40 {
            margin-top: var(--spacing-xl);
        }

        /* Header */
        .header {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: var(--spacing-lg);
        }

        .logo-cell {
            width: 50%;
            vertical-align: middle;
        }

        .logo-cell img {
            width: 260px;
        }

        .logo {
            max-width: 200px;
            height: auto;
        }

        /* Flexbox solution */


        .slogan {
            text-align: right;
            vertical-align: middle;
            color: var(--secondary-color);
        }

        .merged-signature-wrapper {
            position: relative;
            display: inline-block;
            width: 200px;
            /* Adjust based on your images */
            height: 100px;
            margin: 0 auto;
        }

        .stamp-base {
            position: absolute;
            width: 100%;
            object-fit: contain;
            z-index: 1;
            opacity: 0.9;
            filter: brightness(1.1) contrast(0.9);
        }

        .signature-overlay {
            position: absolute;
            width: 70%;
            height: auto;
            object-fit: contain;
            z-index: 2;
            left: 50%;
            top: 30%;
            transform: translate(-50%, -50%);
            mix-blend-mode: multiply;
            opacity: 0.95;
        }


        /* Content Layout */
        .content-grid {
            width: 100%;
            border-collapse: collapse;
            margin: var(--spacing-lg) 0;
        }

        .content-grid td {
            border: none;
            vertical-align: top;
        }

        /* Document Info */
        .document-info {
            width: 70%;
            padding-right: var(--spacing-lg);
        }

        .contact-info {
            width: 30%;
        }

        .info-line {
            margin-bottom: var(--spacing-md);
            line-height: 1.4;
        }

        /* Document Title & Body */
        .document-title {
            margin: var(--spacing-md) 0;
            font-weight: bold;
            font-size: 1.1em;
        }

        .document-body {
            line-height: 1.6;
            margin-bottom: var(--spacing-xl);
        }

        /* Items Table */
        .items-table {
            margin-top: 20px;
            width: 100%;
            border-collapse: collapse;
            margin: var(--spacing-xl) 0;
            page-break-inside: avoid;
        }

        .items-table th,
        .items-table td {
            padding: var(--spacing-sm);
            border-bottom: 1px solid var(--border-color);
        }

        .items-table thead th {
            font-weight: bold;
            background-color: #f8f9fa;
        }

        .separator-row td {
            font-style: italic;
            padding-left: 14px;
            border-bottom: 1px solid var(--border-color);
        }

        /* Totals */
        .totals-container {
            width: 40%;
            margin-left: auto;
            margin-top: var(--spacing-md);
        }

        .totals-table {
            width: 100%;
            border-collapse: collapse;
        }

        .totals-table td {
            padding: 8px 4px;
            text-align: right;
            border-bottom: 1px solid var(--border-color);
        }

        .totals-table tr:last-child td {
            border-bottom: none;
            font-weight: bold;
        }

        .amount-in-words {
            margin-top: var(--spacing-md);
            font-style: italic;
            line-height: 1.4;
        }

        /* Operation Details */
        .operation-details {
            margin-top: var(--spacing-xl);
            width: 100%;
            border-collapse: collapse;
            border: none;
            page-break-inside: avoid;
        }

        .operation-details td {
            border: none;
            vertical-align: top;
        }

        .details-list {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .detail-item {
            margin-bottom: var(--spacing-sm);
        }


        /* Footer */
        .page-footer {
            position: fixed;
            bottom: 0px;
            left: 0;
            right: 0;
            height: 50px;
            font-size: var(--font-size-small);
            z-index: 1000;
        }

        .footer-content {
            width: 100%;
            border-collapse: collapse;
        }

        .footer-content td {
            border: none;
        }

        .company-info {
            line-height: 1.4;
        }

        .company-info strong {
            margin-right: 4px;
        }

        .pagination {
            white-space: nowrap;
            text-align: center;
            min-width: 100px;
        }

        /* Print Styles */
        @media print {
            body {
                font-size: var(--font-size-large);
            }

            .page-footer {
                position: fixed;
            }

            .items-table {
                page-break-inside: avoid;
            }

            .last-page-content {
                page-break-inside: avoid;
            }
        }

        .no-wrap {
            white-space: nowrap;
        }

        @page {
            margin: 50px 50px 50px 50px;
            footer: page-footer;
            header: page-header;
            size: A4;
        }

        .page-number:after {
            content: counter(page);
        }
    </style>
</head>

<body>
    <div @if($operationSettings['hasBackgroundLogo']) style=" background-image: url('logo.png');" class="bg" @endif>
    </div>
    @if (isLegalOperation($operation["docType"]))
    <footer class="page-footer">
        <table class="footer-content">
            <tr>
                <td class="text-right"><span> Page <span class="page-number"></span></span></td>
            </tr>
            <tr>
                <td class="text-center">
                    <div class="company-info">
                        <div>{{ $company["capital"] ?? "" }}</div>
                        <strong>Patente:</strong>{{ $company["patent"] }}
                        <strong>RC:</strong>{{ $company["rc"] }}
                        <strong>IF:</strong>{{ $company["if"] }}
                        <strong>ICE:</strong>{{ $company["ice"] }}
                        <strong>CNSS:</strong>{{ $company["cnss"] }}
                        <strong>RIB:</strong>{{ $company["bank"] }}
                        <strong>Téléphone:</strong>{{ $company["phone"] }}
                        <strong>Email:</strong>{{ $company["email"] }}
                        <div>{{ $company["address"] ?? "" }}</div>
                    </div>
                </td>
            </tr>
        </table>
    </footer>
    @endif

    <div class="container">
        <!-- Header -->
        @if($operationSettings['logoPosition']['value']==='left')
        <table class="header">
            <tr>
                <td class="logo-cell">
                    <img class="logo" src="logo.png" alt="{{ $company[" name"] ?? "" }}">
                </td>
                @if($operationSettings['hasSlogen'])
                <td class="slogan">
                    {{ $company["slogan"] }}<br>
                </td>
                @endif
            </tr>
        </table>
        @elseif($operationSettings['logoPosition']['value']==='right')
        <table class="header">
            <tr>
                @if($operationSettings['hasSlogen'])
                <td class="slogan text-left">
                    {{ $company["slogan"] }}<br> Page <span class="page-number"></span>
                </td>
                @endif
                <td class="logo-cell  text-right">
                    <img class="logo" src="logo.png" alt="{{ $company[" name"] ?? "" }}">
                </td>
            </tr>
        </table>
        @else
        <table class="header">
            <tr>
                <td class="text-center">
                    <div><img class="logo" src="logo.png" alt="{{ $company[" name"] ?? "" }}"></div>
                </td>
            </tr>
            @if($operationSettings['hasSlogen'])
            <tr>
                <td class="text-center">
                    <div> {{ $company["slogan"] }}<br> Page <span class="page-number"></span></div>
                </td>
            </tr>
            @endif
            <tr>
                <td class="text-center">
                    Page <span class="page-number"></span>
                </td>
            </tr>
        </table>
        @endif

        <!-- Document Information -->
        <table class="content-grid">
            <tr>
                <td class="document-info">
                    <div class="info-line bold title">
                        <h3>{{ getDocTypeLabel($operation["docType"]) }} N°:{{ $operation["docId"] ?? "" }} </h3>
                    </div>
                    <div class="info-line">Date: {{ $operation["date"]->format("d/m/Y") ?? "" }}</div>
                    @if ($operation["docType"] === "estimate" && $operation["validateDate"])
                    <div class="info-line">{{ "Valide Jusqu'à" }} :
                        {{ $operation["validateDate"]->format("d/m/Y") ?? "" }}</div>
                    @endif
                    @if ($operation["baseDocId"])
                    <div class="info-line">Référence: {{ $operation["baseDocId"] ?? "" }}</div>
                    @endif
                </td>
                <td class="contact-info">
                    @if (!isInternOperation($operation["docType"]))
                    {{ $operation["counterParty"]["name"] ?? "" }}<br>
                    {{ $operation["counterParty"]["address"]["street"] ?? "" }}<br>
                    {{ $operation["counterParty"]["address"]["city"] ?? "" }}<br>
                    {{ $operation["counterParty"]["address"]["country"] ?? "" }}<br>
                    {{ $operation["counterParty"]["address"]["zipCode"] ?? "" }}<br>
                    {{ $operation["counterParty"]["ice"] ?? "" }}<br>
                    {{ $operation["counterParty"]["contactPerson"] ?? "" }}
                    @else
                    <strong>Responsable {{ "d'opération" }}:</strong>
                    {{ $operation["personInCharge"] ?? "" }}
                    @endif
                </td>
            </tr>
        </table>

        <!-- Document Content -->
        @if ($operation["subject"] && ($operation["docType"] === "purchaseorder" || $operation["docType"] ===
        "estimate"))
        <div class="document-body">{!! nl2br(e($operation["body"])) !!}</div>
        @endif

        <!-- Items Table -->
        <table class="items-table" style="page-break-after: auto;">
            <thead>
                <tr>
                    <th class="text-left">#</th>
                    <th class="text-left">Référence</th>
                    <th class="text-left">Désignation</th>
                    <th class="text-left">Quantité</th>
                    @if (hasPricing($operation["docType"]))
                    <th class="text-left">Unité</th>
                    <th class="text-left  no-wrap">P.U ({{ $operation["currency"]["code"] }})</th>
                    <th class="text-left">Impôt</th>
                    <th class="text-right  no-wrap">Montant ({{ $operation["currency"]["code"] }})</th>
                    @endif
                </tr>
            </thead>
            <tbody>
                @foreach ($operation["items"] as $item)
                @if ($item["isSeparator"] ?? false)
                <tr class="separator-row">
                    <td colspan="{{ hasPricing($operation->docType) ? 8 : 4 }}">
                        {{ $item["separatorName"] ?? "" }}
                    </td>
                </tr>
                @else
                <tr>
                    <td class="text-left">{{ $item["id"] ?? "" }}</td>
                    <td class="text-left">{{ $item["ref"] ?? "" }}</td>
                    <td class="text-left">{{ $item["name"] ?? "" }}</td>
                    <td class="text-left">{{ formatNumber($item["qty"] ?? 0) }}</td>
                    @if (hasPricing($operation["docType"]))
                    <td class="text-left">{{ $item["unit"]['name'] ?? "" }}</td>
                    <td class="text-left no-wrap">{{ formatNumber($item["price"] ?? 0) }} </td>
                    <td class="text-left">
                        {{-- Handle both cases: tax as array with name, or tax as empty array --}}
                        @if (!empty($item["tax"]) && is_array($item["tax"]))
                        {{ $item["tax"]["name"] ?? "" }}
                        @else
                        <!-- no tax -->
                        @endif
                    </td>
                    <td class="text-right no-wrap">{{ formatNumber($item["amount"] ?? 0) }} </td>
                    @endif
                </tr>
                @endif
                @endforeach
            </tbody>
        </table>

        @if (hasPricing($operation["docType"]))
        <!-- Totals Section -->
        <div class="totals-container">
            <table class="totals-table">
                <tr>
                    <td>Total HT :</td>
                    <td>{{ formatNumber($operation["totalHt"]) ?? "" }}
                        {{ $operation["currency"]["code"] ?? "" }}</td>
                </tr>

                @if ($operation["discount"] > 0)
                <tr>
                    <td>Remise ({{ formatNumber(calculatePercentage($operation["totalHt"],$operation["discount"]))}}%) :
                    </td>
                    <td>-{{ formatNumber($operation["discount"]) ?? "" }}
                        {{ $operation["currency"]["code"] ?? "" }}</td>
                </tr>
                <tr>
                    <td>Total HT remisé :</td>
                    <td>{{ formatNumber(safeSubtract($operation["totalHt"], $operation["discount"])) ?? "" }}
                        {{ $operation["currency"]["code"] }}</td>
                </tr>
                @endif

                @if ($operation["tax"] && count($operation["tax"]) > 0)
                @foreach ($operation["tax"] as $tax)
                @if (isset($tax["tax"]) && $tax["tax"] > 0)
                <tr>
                    <td>{{ $tax["name"] ?? "" }} :</td>
                    <td>{{ formatNumber($tax["tax"]) }} {{ $operation["currency"]["code"] }}</td>
                </tr>
                @endif
                @endforeach
                @endif

                <tr>
                    <td class="bold">Total TTC :</td>
                    <td class="bold">{{ formatNumber($operation["totalTtc"] ?? 0) }}
                        {{ $operation["currency"]["code"] ?? "" }}</td>
                </tr>
            </table>
        </div>
        @if ($operation["totalInWord"] && isLegalOperation($operation["docType"]))
        <div class="amount-in-words">{!! nl2br(e($operation["totalInWord"])) !!}</div>
        @endif
        @endif

        <!-- Operation Details & Signature -->
        <table class="operation-details last-page-content">
            <tr>
                @if (!isInternOperation($operation["docType"]))
                <td width="70%">
                    <ul class="details-list">
                        @if ($operation["conditions"])
                        <li class="detail-item">
                            <strong>Conditions:</strong> {{ $operation["conditions"] ?? "" }}
                        </li>
                        @endif

                        @if ($operation["paymentMethod"])
                        <li class="detail-item">
                            <strong>Modes de paiment:</strong>
                            @foreach ($operation["paymentMethod"] as $pm)
                            {{ getMethodOfPayment($pm['value']) ?? "" }},
                            @endforeach
                        </li>
                        @endif

                        @if ($operation["paymentDue"])
                        <li class="detail-item">
                            <strong>Échéance:</strong>
                            {{ $operation["paymentDue"]->format("d/m/Y") ?? "" }}
                        </li>
                        @endif

                        @if ($operation["shippingChargeMode"])
                        <li class="detail-item">
                            <strong>Expédition:</strong>
                            {{ getModeShipping($operation["shippingChargeMode"]) ?? "" }}
                        </li>
                        @endif

                        @if ($operation["shippingFees"] > 0)
                        <li class="detail-item">
                            <strong>Frais:</strong> {{ formatNumber($operation["shippingFees"]) ?? "" }}
                            MAD
                        </li>
                        @endif

                        @if ($operation["expectedArrival"])
                        <li class="detail-item">
                            <strong>Arrivée:</strong>
                            {{ $operation["expectedArrival"]->format("d/m/Y") ?? "" }}
                        </li>
                        @endif
                    </ul>
                </td>
                @endif
                @if(isLegalOperation($operation['docType'] && ($operation["hasSignature"] ||$operation["hasStamp"]) ))
                <td width="30%" class="signature-section">
                    <div class="signature-container">
                        <div class="signature-line">
                            <!-- Container for merged signature and stamp -->
                            <div class="merged-signature-wrapper">
                                <img src="stamp.png" alt="Company Stamp" class="stamp-base">
                                <img src="signature.png" alt="Signature" class="signature-overlay">
                            </div>
                        </div>
                    </div>
                </td>
                @endif
            </tr>
        </table>

        @if (!empty($operation["notes"]))
        <div class="notes-section">
            <span class="notes-label"><strong>Notes:</strong></span>
            <ul>
                @foreach ($operation["notes"] as $note)
                <li>{{ $note }}</li>
                @endforeach
            </ul>
        </div>
        @endif
    </div>
</body>

</html>