<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class translateFromFrJson extends Seeder
{


    public function run()
    {
        $translations = json_decode(file_get_contents(database_path('seeders/fr.json')), true);

        $bulk = [];

        foreach ($translations as $group => $items) {
            foreach ($items as $key => $value) {
                if (is_array($value)) {
                    // Nested subgroup
                    foreach ($value as $subKey => $subValue) {
                        $bulk[] = [
                            'uid'       => Str::uuid(),
                            'name'      => $subKey,
                            'value'     => $subValue,
                            'status'    => 'active',
                            'lang'      => 'fr',
                            'group'     => $group,
                            'subgroup'  => $key,
                        ];
                    }
                } else {
                    $bulk[] = [
                        'uid'       => Str::uuid(),
                        'name'      => $key,
                        'value'     => $value,
                        'status'    => 'active',
                        'lang'      => 'fr',
                        'group'     => $group,
                        'subgroup'  => null,
                    ];
                }
            }
        }

        DB::table('languages')->insert($bulk);
    }
}
