<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pos', function (Blueprint $table) {
            $table->id();
            // Identification
            $table->string('name'); // ex: "Caisse 1"
            $table->string('ref')->unique(); // ex: POS-001

            // State
            $table->string('status')->nullable();
            $table->boolean('isOpen')->default(false);
            // Financial tracking
            $table->decimal('openingBalance', 15, 2)->default(0);
            $table->decimal('currentBalance', 15, 2)->default(0);
            $table->decimal('closingBalance', 15, 2)->nullable();

            // Lifecycle
            $table->timestamp('openedAt')->nullable();
            $table->timestamp('closedAt')->nullable();

            // Ownership / context
            $table->unsignedBigInteger('userId')->nullable();
            $table->foreign('userId')->references('id')->on('users')->onDelete('set null');
            // Cashier / context
            $table->unsignedBigInteger('cashierId')->nullable();
            $table->foreign('cashierId')->references('id')->on('users')->onDelete('set null');
            

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pos');
    }
};
