<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->uuid('uid')->unique();
            $table->string('name');
            $table->string('paymentNumber')->unique();
            $table->string('reference')->unique(); // Payment reference number
            $table->string('operationType')->nullable(); // Sale or Purchase
            $table->json('paymentmethod')->nullable();
            $table->decimal('amount', 15, 2)->nullable(); // Payment amount
            $table->json('currency')->nullable();
            $table->string('status')->nullable()->default('unpaid');
            $table->date('paymentDate')->nullable();
            $table->json('counterParty')->nullable();
            $table->foreignId('operationId')->nullable()->constrained('operations')->nullOnDelete();
            $table->foreignId('bankAccountId')->nullable()->constrained('bankaccounts')->nullOnDelete();
            $table->foreignId('createdBy')->nullable()->constrained('users')->nullOnDelete();
            $table->text('notes')->nullable();
            $table->string('chequeNumber')->nullable();
            $table->date('dueDate')->nullable();
            $table->string('bankName')->nullable();
            $table->string('owner')->nullable();
            $table->string('beneficiary')->nullable();
            $table->softDeletes();
            $table->timestamps();
            $table->index('paymentNumber');
            $table->index('paymentDate');
            $table->index('bankAccountId');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
