<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bankaccounts', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->enum('type', ['bank', 'cash', 'petty_cash', 'other'])->nullable()->default('bank');
            $table->string('status')->nullable()->default('active');
            $table->string('bankName')->nullable();
            $table->string('accountNumber')->nullable();
            $table->string('swift')->nullable();
            $table->string('bic')->nullable();
            $table->string('iban')->nullable();
            $table->decimal('initial_balance', 15, 3)->nullable()->default(0);
            $table->decimal('balance', 15, 3)->nullable()->default(0);
            $table->json('currency')->nullable();
            $table->unsignedBigInteger('companyId')->nullable();
            $table->string('description')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bankaccounts');
    }
};
