<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tables', function (Blueprint $table) {
            $table->id();

            // Basic info
            $table->string('tableNumber')->unique();  // رقم الطاولة
            $table->string('name')->nullable();       // optional name (ex: VIP 1)

            // Capacity
            $table->integer('seats')->default(1);     // عدد الكراسي

            // Status
             $table->string('status')->nullable();

            // Location (optional)
            $table->string('area')->nullable();       // ex: Terrasse, Inside, Lounge
            $table->string('floor')->nullable();


            // QR / digital menu
            $table->string('qrCodeUrl')->nullable();  // رابط QR menu

            // Description
            $table->longText('description')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tables');
    }
};
