<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('absences', function (Blueprint $table) {
            $table->id();
            $table->string('uid')->unique();
            $table->string('name')->nullable();
            $table->integer('employee_id')->nullable();
            $table->integer('employee_pid')->nullable();
            $table->string('status')->nullable()->default('unjustified');
            $table->json('employee')->nullable();
            $table->string('type')->nullable();
            $table->date('date')->nullable();
            $table->text('comment')->nullable();
            $table->json('documents')->nullable();
            $table->unique(['employee_id', 'date']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('absences');
    }
};
