<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('advances', function (Blueprint $table) {
            $table->id();
            $table->string('uid')->unique();
            $table->string('name')->nullable();
            $table->integer('employee_id')->nullable();
            $table->string('status')->nullable()->default('requested');
            $table->date('dateDeduction')->nullable();
            // معلومات الموظف
            $table->json('employee')->nullable();
            $table->decimal('amount', 18, 4)->nullable();
            $table->text('raison')->nullable();
            $table->text('replay')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('advances');
    }
};
