<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('allowances', function (Blueprint $table) {
            $table->id();
            $table->string('uid')->unique();
            $table->string('status')->nullable()->default('active');
            $table->string('name')->nullable(); // 🔹 الاسم الظاهر للتعويض (مثلاً: تعويض النقل، تعويض المهمة...)
            $table->decimal('amount', 12, 2)->nullable(); // 🔹montant brut
            $table->boolean('taxable')->nullable()->default(true); // 🔹 واش التعويض خاضع للضريبة على الدخل ؟ (true = خاضع، false = معفي)
            $table->boolean('isCnssContributable')->nullable()->default(true); // 🔹 واش التعويض يدخل فحساب الاشتراك CNSS ؟ (true = يدخل، false = معفي)
            $table->decimal('exemptionLimit', 10, 2)->nullable(); // 🔹 الحد الأقصى المعفي (مثلاً 500 درهم فتعويض النقل)
            $table->decimal('taxableAmount', 12, 2)->nullable(); // 🔹 الجزء الخاضع للضريبة (إذا كان معفي جزئياً أو كلياً)
            $table->decimal('cnssBaseAmount', 12, 2)->nullable();// 🔹 الجزء اللي يدخل فأساس حساب CNSS
             // $table->json('meta')->nullable(); // 🔹 بيانات إضافية (مثلاً المسافة بالكيلومتر، رقم أمر المهمة...)
            $table->text('description')->nullable(); // 🔹 وصف إضافي للتعويض، الهدف منه أو شروطه القانونية
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('allowances');
    }
};
