<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payrolls', function (Blueprint $table) {
            $table->id();
            // Identification
            $table->uuid('uid')->unique();
            $table->foreignId('employee_id')->nullable()->constrained('employees')->nullOnDelete();
            $table->string('name')->nullable();
            $table->json('employeeData')->nullable();
            $table->string('status')->default('pending');
            $table->date('date')->nullable();
            $table->string('month')->nullable();
            $table->integer('calculation_year')->nullable();
            // Working time & attendance
            $table->decimal('totalWorkedRegularHours', 10, 2)->default(0);
            $table->decimal('totalWorkedSuppDayHours', 10, 2)->default(0);
            $table->decimal('totalWorkedSuppNightHours', 10, 2)->default(0);
            $table->decimal('totalWorkedSuppHolyDaysHours', 10, 2)->default(0);
            $table->decimal('totalWorkedweekendHours', 10, 2)->default(0);
            $table->decimal('totalWorkedHours', 10, 2)->default(0);
            $table->json('detailSuppl')->nullable();
            $table->decimal('leaveDays', 10, 2)->default(0);
            $table->decimal('absenceDaysUnJustified', 10, 2)->default(0);
            $table->decimal('absenceDaysJustified', 10, 2)->default(0);
            $table->decimal('totalAdvance', 10, 2)->default(0);
            // Employee details
            // SMIG compliance
            $table->boolean('smig_compliant')->default(true);
            $table->decimal('smig_minimum_required', 10, 2)->nullable();
            $table->decimal('smig_deficit', 10, 2)->nullable();
            // Compensation
            $table->json('compensation')->nullable();
            $table->decimal('taxableCompensations', 10, 2)->default(0);
            $table->decimal('nonTaxableCompensations', 10, 2)->default(0);

            // Bases & social security
            $table->decimal('cnssBase', 10, 2)->default(0);

            // Employee deductions
            $table->decimal('cnss', 10, 2)->default(0);
            $table->string('cnssRate')->nullable();

            $table->decimal('amo', 10, 2)->default(0);
            $table->string('amoRate')->nullable();

            $table->decimal('lossJobCompensation', 10, 2)->default(0);
            $table->string('lossJobRate')->nullable();
             $table->json('detailIr')->nullable();
            $table->decimal('ir', 10, 2)->default(0);
            $table->string('irRate')->nullable();
            $table->decimal('tax_credit', 10, 2)->default(0);


            $table->decimal('proFees', 10, 2)->default(0);
            $table->string('proFeesRate')->nullable();

            $table->decimal('retirement', 10, 2)->default(0);
            $table->string('retirementRate')->nullable();

            // Employer contributions
            $table->decimal('employer_cnss', 10, 2)->default(0);
            $table->string('employer_cnss_rate')->nullable();

            $table->decimal('employer_amo', 10, 2)->default(0);
            $table->string('employer_amo_rate')->nullable();

            $table->decimal('employer_ipe', 10, 2)->default(0);
            $table->string('employer_ipe_rate')->nullable();

            $table->decimal('employer_family_allowance', 10, 2)->default(0);
            $table->string('employer_family_allowance_rate')->nullable();

            $table->decimal('employer_tfp', 10, 2)->default(0);
            $table->string('employer_tfp_rate')->nullable();

            $table->decimal('total_employer_cost', 12, 2)->default(0);

            // Totals
            $table->json('detailGrossSalary')->nullable();
            $table->decimal('grossSalary', 12, 2)->default(0);
            $table->decimal('totalDeductions', 12, 2)->default(0);
            $table->decimal('netSalary', 12, 2)->default(0);
            $table->decimal('total_social_security', 12, 2)->default(0);
            $table->string('netSalaryInWord')->nullable();

            // HR metadata
            $table->string('generatedBy')->nullable();
            $table->string('approvedBy')->nullable();
            $table->date('approvedAt')->nullable();

            // Notes
            $table->text('note')->nullable();
            $table->unique(['employee_id', 'calculation_year', 'month','deleted_at']);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payrolls');
    }
};
