<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('leaves', function (Blueprint $table) {
            $table->id();
            $table->string('uid')->unique();
            $table->string('name')->nullable();
            $table->integer('employee_id')->nullable();
            $table->integer('employee_pid')->nullable();
            $table->string('status')->nullable()->default('requested');
            // معلومات الموظف
            $table->json('employee')->nullable();
            $table->string('type')->nullable();
            $table->date('start')->nullable();
            $table->date('end')->nullable();
            $table->integer('countedDays')->nullable()->default(0);
            $table->string('daysOriginOff')->nullable();
            $table->integer('concretDays')->nullable()->default(0);
            $table->text('comment')->nullable();
            $table->text('replay')->nullable();
            $table->unique(['employee_id', 'start' , 'end'])->whereNull('deleted_at');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('leaves');
    }
};
