<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('attendances', function (Blueprint $table) {
            $table->id();
            $table->string('uid')->nullable();
            $table->string('name')->nullable();
            $table->integer('employee_id')->nullable();
            $table->integer('employee_pid')->nullable();
            $table->string('status')->nullable()->default('active');
            $table->json('employee')->nullable();
            $table->string('type')->nullable();
            $table->datetime('date')->nullable();
            $table->time('start')->nullable();
            $table->time('break')->nullable();
            $table->decimal('breakDuration', 18, 2)->nullable();
            $table->time('end')->nullable();
            $table->decimal('lateWith', 18, 2)->nullable();
            $table->decimal('outEarlierWith', 18, 2)->nullable();
            $table->decimal('workedRegularHours', 18, 2)->nullable();
            $table->decimal('workedSuppDayHours', 18, 2)->nullable();
            $table->decimal('workedSuppNightHours', 18, 2)->nullable();
            $table->decimal('workedSuppHolyDaysHours', 18, 2)->nullable();
            $table->decimal('workedWeekendHours', 18, 2)->nullable();
            $table->text('comment')->nullable();
            $table->unique(['employee_id', 'date'])->whereNull('deleted_at');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('attendances');
    }
};
