<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('employees', function (Blueprint $table) {
            $table->id();

            // 🔹 Identification
            $table->string('uid')->unique();                    // Unique identifier
            $table->string('name');                              // Full name
            $table->string('status')->nullable()->default('active');         // Employment status
            $table->string('matricule')->nullable();             // Employee internal number/code
            $table->string('pid')->nullable();
            $table->string('fname')->nullable();                 // First name
            $table->string('lname')->nullable();
            $table->string('cin')->nullable();
            $table->date('birthday')->nullable();                // Date of birth
            $table->integer('age')->nullable();                  // Age
            $table->string('nationality')->nullable();           // Nationality
            $table->string('passportNumber')->nullable();        // Passport (for expatriates)
            $table->string('phone')->nullable();                 // Phone number
            $table->string('email')->unique()->nullable();       // Email address
            $table->string('address')->nullable();                // City

            // 🔹 payrollBank
            $table->string('payrollType')->nullable();
            $table->string('salaryType')->nullable();
            $table->string('paymentMethod')->nullable();             // Monthly / Hourly / Fixed
            $table->decimal('salary', 12, 2)->nullable();
            $table->decimal('hourPrice', 8, 2)->nullable();
            $table->json('allowances')->nullable();
            $table->json('deductions')->nullable();
            $table->decimal('remainingFromDeductions', 18, 2)->nullable();
            $table->string('bankAccount')->nullable();
            $table->string('bankName')->nullable();
            $table->string('rib')->nullable();
            $table->string('iban')->nullable();

            // 🔹 Job & Contract
            $table->string('jobTitle')->nullable();
            $table->string('department')->nullable();
            $table->string('grade')->nullable();
            $table->string('employmentType')->nullable();
            $table->string('contractType')->nullable();
            $table->date('hireDate')->nullable();
            $table->date('lastTestDate')->nullable();
            $table->date('contractEndDate')->nullable();
            $table->date('noticeterminationDate')->nullable();
            $table->integer('noticePeriod')->nullable();
            $table->date('terminationDate')->nullable();
            $table->string('workLocation')->nullable();
            $table->string('workingHours')->nullable();
            $table->json('supervisor')->nullable();
            $table->decimal('leaveBalance', 12, 2)->nullable();
            $table->integer('sickLeaveBalance')->nullable();
            $table->boolean('hasRetirementPlan')->nullable();
            $table->boolean('hasInsurance')->nullable();
            $table->string('socialNotes')->nullable();
            $table->integer('performance')->nullable();

            // 🔹 Case of contract of project
            $table->string('project_id')->nullable()->comment('id of project');
            $table->date('projectStart')->nullable();
            $table->date('projectEnd')->nullable();
            $table->boolean('projectCompleted')->default(false);

            // 🔹 Family & Social
            $table->string('maritalStatus')->nullable();
            $table->integer('childrenNumber')->nullable();
            $table->integer('relatedPerson')->nullable();
            $table->string('emergencyContactName')->nullable();
            $table->string('emergencyContactPhone')->nullable();
            $table->string('emergencyContactRelation')->nullable();
            $table->string('cnssNumber')->nullable();
            $table->string('retirementProvider')->nullable();
            $table->string('insuranceCompany')->nullable();
            $table->string('insuranceNumber')->nullable();
            $table->string('insuranceDays')->nullable();
            $table->integer('daysDeclared')->nullable()->default(0);
            $table->decimal('salaryDeclared', 12, 2)->nullable();
            // 🔹 Documents & Files

            // 🔹 Documents & Files
            $table->json('avatar')->nullable();
            $table->json('cv')->nullable();
            $table->json('diplome')->nullable();
            $table->json('idCard')->nullable();
            $table->json('contract')->nullable();
            $table->json('passport')->nullable();

            $table->integer('performanceScore')->nullable();
            $table->text('notes')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('employees');
    }
};
