<?php

return [

    // 💼 Supplementary types
    'supplementary_types' => [
        'suppDay' => [
            'label' => 'Heures supplémentaires de jour',
            'rate' => 1.25,
            'rateLabel' => '+25%',
        ],
        'suppNight' => [
            'label' => 'Heures supplémentaires de nuit',
            'rate' => 1.5,
            'rateLabel' => '+50%',
        ],
        'suppHoly' => [
            'label' => 'Heures jours fériés',
            'rate' => 2.0,
            'rateLabel' => '+100%',
        ],
        'weekend' => [
            'label' => 'Heures week-end',
            'rate' => 1.5,
            'rateLabel' => '+50%',
        ],
    ],

    // 📊 CNSS
    'cnss' => [
        'employee_rate' => env('CNSS_EMPLOYEE_RATE', 0.0429),
        'employer_rate' => env('CNSS_EMPLOYER_RATE', 0.086),
        'total_rate' => env('CNSS_TOTAL_RATE', 0.1289),
        'cap' => env('CNSS_CAP', 6000),
        'rate' => env('CNSS_RATE', 0.0448),
        'floor' => env('CNSS_FLOOR', 3266.1),
    ],

    // 📊 AMO
    'amo' => [
        'employee_rate' => env('AMO_EMPLOYEE_RATE', 0.0185),
        'employer_rate' => env('AMO_EMPLOYER_RATE', 0.0411),
        'total_rate' => env('AMO_TOTAL_RATE', 0.0637),
        'cap' => env('AMO_CAP', null),
        'rate' => env('AMO_RATE', 0.0231),
        'floor' => env('AMO_FLOOR', 3266.1),
    ],

    // 📊 IPE
    'ipe' => [
        'employee_rate' => env('IPE_EMPLOYEE_RATE', 0.0019),
        'employer_rate' => env('IPE_EMPLOYER_RATE', 0.0038),
        'total_rate' => env('IPE_TOTAL_RATE', 0.0057),
        'cap' => env('IPE_CAP', 6000),
    ],

    // 📊 TFP
    'tfp' => [
        'employee_rate' => env('TFP_EMPLOYEE_RATE', 0.0),
        'employer_rate' => env('TFP_EMPLOYER_RATE', 0.016),
        'total_rate' => env('TFP_TOTAL_RATE', 0.016),
        'cap' => env('TFP_CAP', null),
    ],

    // 📊 SMIG
    'smig' => [
        'hourly' => env('SMIG_HOURLY_2025', 17.1),
        'monthly_hours' => env('SMIG_MONTHLY_HOURS_2025', 191),
        'monthly' => env('SMIG_MONTHLY_2025', 3266.1),
    ],

    // 📊 IR brackets
    'ir_brackets' => [
        ['max' => 3333.33, 'rate' => 0.0, 'deduction' => 0],
        ['max' => 5001.0, 'rate' => 0.1, 'deduction' => 333.33],
        ['max' => 6666.67, 'rate' => 0.2, 'deduction' => 833.33],
        ['max' => 8333.33, 'rate' => 0.3, 'deduction' => 1500],
        ['max' => 15000.0, 'rate' => 0.34, 'deduction' => 1833.33],
        ['max' => null, 'rate' => 0.37, 'deduction' => 2283.33],
    ],

    'tax_credit_per_dependent' => 41.67,

    // 📊 Exemption limits
    'exemption_limits' => [
        'transport' => 500,
        'meal' => 300,
        'family' => 300,
        'housing' => 2500,
    ],

];
