<?php
namespace App\data;

class ItemDTO
{
    public ?int $id;
    public string $ref;
    public string $name;
    public float $qty;
    public float $price;
    public float $amount;
    public string $unit;
    public bool $isSeparator;
    public ?string $separatorName;
    public ?string $description;
    public ?string $note;

    public array $product;   // ItemProductDTO
    public array $tax;       // ItemTaxDTO

    public function __construct(array $item)
    {
        $this->id = $item['id'] ?? null;
        $this->ref = $item['ref'] ?? '';
        $this->name = $item['name'] ?? '';
        $this->qty = (float) ($item['qty'] ?? 0);
        $this->price = (float) ($item['price'] ?? 0);
        $this->amount = (float) ($item['amount'] ?? 0);
        $this->unit = $item['unit'] ?? '';
        $this->isSeparator = $item['isSeparator'] ?? false;
        $this->separatorName = $item['separatorName'] ?? null;
        $this->description = $item['description'] ?? null;
        $this->note = $item['note'] ?? null;


    }

    public function toArray(): array
    {
        return [
            ...get_object_vars($this),
            'product' => [],
            'tax' => [],
        ];
    }
}

