<?php

namespace App\Models\STOCK;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Contracts\Auditable;
use App\Models\OPERATION\Operation;

class Warehouse extends Model implements Auditable
{
    use HasFactory, SoftDeletes, \OwenIt\Auditing\Auditable;

    protected $table = 'warehouses';
    protected $fillable = [
        'name',
        'location',
        'responsible',
        'phone',
        'email',
        'status',
    ];

    public function operations()
    {
        return $this->hasMany(Operation::class, 'warehouse');
    }

    public function outgoingOperations()
    {
        return $this->hasMany(Operation::class, 'fromWarehouse');
    }

    public function incomingOperations()
    {
        return $this->hasMany(Operation::class, 'toWarehouse');
    }
}
