<?php

namespace App\Models\HRM;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\Casts\Attribute;

class Absence extends Model implements Auditable
{
    use HasFactory,  \OwenIt\Auditing\Auditable;
    protected $fillable = [
        'uid',
        'employee_id',
        'employee_pid',
        'name',
        'status',
        'employee',
        'type',
        'date',
        'comment',
        'documents'
    ];

    const STATUS_JUSTIFIED = 'justified';
    const STATUS_UNJUSTIFIED = 'unjustified';

    protected $casts = [
        'date' => 'datetime',
    ];

    protected function employee(): Attribute
    {
        return Attribute::make(
            get: fn($value) => json_decode($value, true),
            set: fn($value) => json_encode($value),
        );
    }




    protected static function boot()
    {
        parent::boot();
        static::creating(function ($model) {
            if (empty($model->uid)) {
                $model->uid = (string) Str::ulid();
            }

            // Safely decode employee if it's a string
            $employeeData = is_string($model->employee) ? json_decode($model->employee, true) : $model->employee;

            if (!empty($employeeData)) {
                $model->name = $employeeData['name'] ?? null;
                $model->employee_id = $employeeData['id'] ?? null;
                $model->employee_pid = $employeeData['pid'] ?? null;
            }

        });

        static::updating(function ($model) {
            // Safely decode employee
            $employeeData = is_string($model->employee) ? json_decode($model->employee, true) : $model->employee;

            if ($model->isDirty('employee') && !empty($employeeData)) {
                $model->name = $employeeData['name'] ?? null;
                $model->employee_id = $employeeData['id'] ?? null;
                $model->employee_pid = $employeeData['pid'] ?? null;
            }
        });
    }
}
