<?php

namespace App\Models\CRM;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Str;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\Casts\Attribute;
use App\Models\OPERATION\Operation;
class Client extends Model implements Auditable
{
    use HasFactory, SoftDeletes, \OwenIt\Auditing\Auditable;

    protected $fillable = [
        'uid',             // Unique ID auto-generated
        'name',            //  اسم العميل
        'status',          // active / inactive
        'ice',             // Identifiant Commun de l'Entreprise
        'rc',              // Registre de Commerce
        'taxNumber',      // رقم ضريبي (optional)
        'email',           // البريد الإلكتروني
        'phone',           // رقم الهاتف
        'address',         // العنوان
        'contactPerson',  // الشخص المسؤول
        'balance',          // رصيد المورد الحالي
        'turnover',        // Chiffer d'affaire  job
        'paymentPerms',   // شروط الدفع
        'description',     // ملاحظات إضافية
    ];

    protected function address(): Attribute
    {
        return Attribute::make(
            get: fn($value) => json_decode($value, true),
            set: fn($value) => json_encode($value),
        );
    }

    protected static function boot()
    {
        parent::boot();
        static::creating(function ($model) {
            if (empty($model->uid)) {
                $model->uid = (string) Str::ulid();
            }
        });
    }

    public function operations(){
        return $this->hasMany(Operation::class, 'clientId');
    }
}
