<?php

namespace App\Mail;


use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class GeneralNotificationMail extends Mailable
{
    use Queueable, SerializesModels;

    public $subjectText;
    public $bodyText;
    public $docId;
    public $docType;
    public $pdf; // 👈

    public function __construct($subject, $body, $docId, $docType = null, $pdf = null)
    {
        $this->subjectText = $subject;
        $this->bodyText = $body;
        $this->docId = $docId;
        $this->docType = $docType;
        $this->pdf = $pdf;
    }

    public function build()
    {
        
        $mail = $this->subject($this->subjectText)
            ->view('operation.mail')
            ->with([
                'body' => $this->bodyText,
                'docType' => $this->docType,
                'subject' => $this->subjectText,
                'docId' => $this->docId,
            ]);
            

        // 📎 Attach PDF if exists
        if ($this->pdf) {
            $mail->attachData(
                $this->pdf,
                 getDocTypeLabel($this->docType).'-'.$this->docId.'.pdf',
                ['mime' => 'application/pdf']
            );
        }
    

        return $mail;
    }
}
