<?php

namespace App\Jobs;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use App\Models\STOCK\Stocklog;
use Illuminate\Support\Facades\Log;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SetStockLog implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    protected $data;

    /**
     * Create a new job instance.
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        try {
            Stocklog::create([
                'productId'     => $this->data['productId'] ?? null,
                'batch'         => $this->data['batch'] ?? null,
                'productName'   => $this->data['productName'] ?? null,
                'productCode'   => $this->data['productCode'] ?? null,
                'operationType' => $this->data['operationType'] ?? null,
                'operationCode' => $this->data['operationCode'] ?? null,
                'quantity'      => $this->data['quantity'] ?? null,
                'unite'         => $this->data['unite'] ?? null,
                'price'         => $this->data['price'] ?? null,
                'operator'      => $this->data['operator'] ?? null,
                'operatorId'    => $this->data['operatorId'] ?? null,
                'warehouse'     => $this->data['warehouse'] ?? null,
                'warehouseId'   => $this->data['warehouseId'] ?? null,
                'date'          => now()->format('Y-m-d H:i:s'),
            ]);
        } catch (\Throwable $e) {
            Log::error("Failed to create stock log for product  {$this->data['productId']} => {$e->getMessage()}");
        }
    }
}
