<?php

namespace App\Jobs;

use App\Mail\GeneralNotificationMail;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;

class SendGeneralNotificationEmail implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $email;
    public $subject;
    public $body;
    public $items;
    public $docType;

    public function __construct($email, $subject, $body, $items, $docType = null)
    {
        $this->email   = $email;
        $this->subject = $subject;
        $this->body    = $body;
        $this->items   = $items;
        $this->docType = $docType;
    }

    public function handle()
    {
        Mail::to($this->email)->send(
            new GeneralNotificationMail(
                $this->subject,
                $this->body,
                $this->items,
                $this->docType
            )
        );
    }
}
