<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class JwtCookieMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        // إلا كان الكوكي "access_token" موجود وما عندناش Authorization header
        if ($request->hasCookie('access_token') && !$request->headers->has('Authorization')) {
            $token = $request->cookie('access_token');
            $request->headers->set('Authorization', 'Bearer ' . $token);
        }

        return $next($request);
    }
}
