<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\admin\Setting;
use Illuminate\Http\Request;
use App\Traits\CrudTrait;
use Illuminate\Support\Facades\File;

class SettingController extends Controller
{
    use CrudTrait;

    protected string $modelClass = Setting::class;
    protected string $dataType = 'object';

    public function index(Request $request)
    {
        return $this->getData($request);
    }

    public function store(Request $request)
    {
        return $this->storeData($request);
    }

    public function bulkStore(Request $request)
    {
        return $this->bulkStore($request);
    }

    public function update(Request $request)
    {
        $delta = $request->all(); // delta فقط

        // Safe access
        $logoPath = data_get($delta, 'company.logo.path');
        $signaturePath = data_get($delta, 'company.signature.path');
        $stampPath = data_get($delta, 'company.stamp.path');



        $docIdPattern = data_get($delta, 'operation.docIdPattern');
        $docIdPatternHasDate= data_get($delta, 'operation.docIdPatternHasDate');
        $hasPix = data_get($delta, 'operation.docIdHasPrefix');
        $handleStockWithInOut = data_get($delta, 'operation.handleStockWithInOut');
        $updatePriceAfterSaleAndPurchase = data_get($delta, 'operation.updatePriceAfterSaleAndPurchase');

        if ($docIdPattern !== null) {
            setEnvValue('DOCID_PATTERN', $docIdPattern);
        }

        if ($docIdPatternHasDate !== null) {
            setEnvValue('DOCID_PATTERN_HAS_DATE', $docIdPatternHasDate);
        }

        if ($hasPix !== null) {
            setEnvValue('HASPIX', $hasPix);
        }

        if ($handleStockWithInOut !== null) {
            setEnvValue('HANDLE_STOCK_WITH_IN_OUT', $handleStockWithInOut);
        }

        if ($updatePriceAfterSaleAndPurchase !== null) {
            setEnvValue('UPDATE_PRICE_AFTER_OPERATION', $updatePriceAfterSaleAndPurchase);
        }


        $this->copyAsset($logoPath, 'logo.png');
        $this->copyAsset($signaturePath, 'signature.png');
        $this->copyAsset($stampPath, 'stamp.png');

        return $this->updateData($request);
    }

    private function copyAsset(?string $path, string $target)
    {
        if (!$path) return;

        $parsed = parse_url($path);
        if (!isset($parsed['path'])) return;

        $localPath = public_path($parsed['path']);
        $destination = public_path($target);

        if (File::exists($localPath)) {
            File::delete($destination);
            File::copy($localPath, $destination);
        }
    }


    public function bulkUpdate(Request $request)
    {
        return $this->multiUpdate($request);
    }

    public function destroy(Request $request)
    {
        return $this->destroyData($request);
    }

    public function bulkDestory(Request $request)
    {
        return $this->bulkDelete($request);
    }

    public function clone(Request $request)
    {
        return $this->cloneData($request);
    }

    public function export(Request $request)
    {
        return $this->exportData($request);
    }

    public function import(Request $request)
    {
        return $this->importData($request);
    }

    public function upload(Request $request)
    {
        return $this->uploadFile($request);
    }

    public function download(Request $request)
    {
        return $this->downloadFile($request);
    }
}
