<?php

namespace App\Http\Controllers\STOCK;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Traits\CrudTrait;
use App\Models\STOCK\Immobilisation;

class ImmobilisationController extends Controller
{
    use CrudTrait;

    protected string $modelClass = Immobilisation::class;
    protected string $dataType = 'object';
    //this will get the Leave rows and load it after every scan
    public function index(Request $request)
    {
        return $this->getData($request);
    }

    public function bulkDestory(Request $request)
    {
        return $this->bulkDelete($request);
    }

    public function export(Request $request)
    {
        return $this->exportData($request);
    }

}
